<fieldset class="panel-list">
	<div class="alert alert-info">
			<p>
				{l s='Put this special tag in any tpl file to get images' mod='pshowgallery'}:<br>
				{literal}{hook h='PShowGalleryGetImages' id_album='1' method='link'}{/literal}<br>
				{l s='Variables' mod='pshowgallery'}:<br>
				{l s='id_album = here you can entry id of album from which you want to display images' mod='pshowgallery'}<br>
				{l s='id_image = here you can entry id of image which will be display' mod='pshowgallery'}<br>
				{l s='limit = limit of images to display' mod='pshowgallery'}<br>
				{l s='columns_width_xs = number of xs bootstrap columns per row' mod='pshowgallery'}<br>
				{l s='columns_width_sm = number of sm bootstrap columns per row' mod='pshowgallery'}<br>
				{l s='columns_width_md = number of md bootstrap columns per row' mod='pshowgallery'}<br>
				{l s='columns_width_lg = number of lg bootstrap columns per row' mod='pshowgallery'}<br>
				{l s='isSlider = 1 - images show in slider, 0 - images show as list' mod='pshowgallery'}<br>
				{l s='id_slider = if in isSlider you choose 1, you must set this variable as id of slider' mod='pshowgallery'}<br>
				{l s='title = title of images list' mod='pshowgallery'}<br>
				{l s='showInProduct = display in the selected product' mod='pshowgallery'}<br>
				{l s='showInCategory = display in the selected category' mod='pshowgallery'}<br>
				{l s='id_category = category id in which the images are to be displayed' mod='pshowgallery'}<br>
				{l s='id_product = product id in which the images are to be displayed' mod='pshowgallery'}
			</p>
		</div>
</fieldset>

{if version_compare($smarty.const._PS_VERSION_, '1.6.0.0', '<')}
	{include file="./image_15.tpl"}
{else}
	{include file="./image_bootstrap.tpl"}
{/if}

<script type="text/javascript">
	var token = '{$token}';
	var id_album = '{$id_pshow_gallery_album}';
	var img_pub_path = '{$img_pub_path}';
	var uploadURL = "{$link->getAdminLink('PShowGalleryImage')}&page=addimage&id_album={$smarty.get.id_pshow_gallery_album}"; //Upload URL
	var originalOrder = false;
	
	{literal}
	$(document).ready(function(){
		{/literal}
		var cookieSort = $.cookie("PSHOW_GALLERY_IMAGES_SORTED");
		if(cookieSort !== 'undefined') {
			if(cookieSort == 1) {
				$(".icon_sort_order").removeClass("icon_sort_up");
				$(".icon_sort_order").addClass("icon_sort_down");
				$(".icon_sort_date").removeClass("icon_sort_up");
				$(".icon_sort_date").removeClass("icon_sort_down");
				$(".icon_sort_order").removeClass("icon_empty");
				$(".icon_sort_date").addClass("icon_empty");
			}
			else if(cookieSort == 2) {
				$(".icon_sort_order").addClass("icon_sort_up");
				$(".icon_sort_order").removeClass("icon_sort_down");
				$(".icon_sort_date").removeClass("icon_sort_up");
				$(".icon_sort_date").removeClass("icon_sort_down");
				$(".icon_sort_order").removeClass("icon_empty");
				$(".icon_sort_date").addClass("icon_empty");
			}
			else if(cookieSort == 3) {
				$(".icon_sort_order").removeClass("icon_sort_up");
				$(".icon_sort_order").removeClass("icon_sort_down");
				$(".icon_sort_date").removeClass("icon_sort_up");
				$(".icon_sort_date").addClass("icon_sort_down");
				$(".icon_sort_order").addClass("icon_empty");
				$(".icon_sort_date").removeClass("icon_empty");
			}
			else {
				$(".icon_sort_order").removeClass("icon_sort_up");
				$(".icon_sort_order").removeClass("icon_sort_down");
				$(".icon_sort_date").addClass("icon_sort_up");
				$(".icon_sort_date").removeClass("icon_sort_down");
				$(".icon_sort_order").addClass("icon_empty");
				$(".icon_sort_date").removeClass("icon_empty");
			}
		}
		$(document).on('click', '#table_date', function()
		{
			if(confirm('{l s='All images will sort by add date. Are you sure?'}')) {
			    var cookieSort = $.cookie("PSHOW_GALLERY_IMAGES_SORTED");
			    if(cookieSort !== 'undefined') {
					if(cookieSort == 3) {
						$.cookie("PSHOW_GALLERY_IMAGES_SORTED", 4, { expires : 1, path : '/'});
					}
					else {
						$.cookie("PSHOW_GALLERY_IMAGES_SORTED", 3, { expires : 1, path : '/'});
					}
				}
				location.reload();
			}
		});
		
		$(document).on('click', '#table_order', function()
		{
			if(confirm('{l s='All images will sort by position. Are you sure?'}')) {
			    var cookieSort = $.cookie("PSHOW_GALLERY_IMAGES_SORTED");
			    if(cookieSort !== 'undefined') {
					if(cookieSort == 1) {
						$.cookie("PSHOW_GALLERY_IMAGES_SORTED", 2, { expires : 1, path : '/'});
					}
					else {
						$.cookie("PSHOW_GALLERY_IMAGES_SORTED", 1, { expires : 1, path : '/'});
					}
				}
				location.reload();
			}
		});
		
		$( "#table_date" ).hover(function() {
		  		$("#table_date").css("text-decoration", "underline"); 
			}, function() {
	       		$("#table_date").css("text-decoration", "none"); 
	    });
		
		$( "#table_order" ).hover(function() {
		  		$("#table_order").css("text-decoration", "underline"); 
			}, function() {
	       		$("#table_order").css("text-decoration", "none"); 
	    });
	    
		{foreach from=$images item=image}
			description = {literal}"{"{/literal};
			
			{foreach from=$languages item=language}
				description += '"{$language.id_lang}":"{$image->description[$language.id_lang]}",';
			{/foreach}
			
			if (description != {literal}"{"{/literal})
			{
				description = description.slice(0, -1);
				description += {literal}"}"{/literal};
				description = jQuery.parseJSON(description);
			}
			else
				description = false;
			
			imageLine(
				{$image->id},
				"{$img_pub_path}thumb_{$image->id}.jpg",
				{$image->position},
				{$image->cover},
				description,
				{$image->active},
				"{$image->date_add}"
			);
		{/foreach}
		{literal}
		
		reloadTable();

        $(document).on('click', '.save_description', function(e)
		{
			e.preventDefault();
			
			var lang_fields = $(this).parent().parent().find('.translatable-field');
			var id = $(this).parents('tr').attr('id');
			var desc = "{";
			
			$(lang_fields).each(function(key, value)
			{
				var val = $(this).find('input').val();
				var id_lang = $(this).find('input').attr('name');
				
				id_lang = id_lang.split('_');
				desc += '"' + id_lang[1] + '":"' + val + '",';
			});
			desc = desc.slice(0, -1);
			desc += "}";
			
			$.ajax(
			{
				url: currentIndex + '&token=' + token + '&ajax=' + 1,
				method: 'POST',
				async: true,
				dataType: 'json',
				data: {
					'ajax': true,
					'action': 'description',
					'description': desc,
					'id_image': id
				},
				success: function(data)
				{
					if (data.success) 
						showSuccessMessage(data.text);
					else
						showErrorMessage(data.text);
				}
			});
		});

        $(document).on('click', '.delete_image', function(e)
		{
			e.preventDefault();
			
			var id = $(this).parent().parent().attr('id');
			
			if (confirm("{/literal}{l s='Are you sure?' js=1}{literal}"))
			{
				$.ajax(
				{
					url: currentIndex + '&token=' + token + '&ajax=' + 1,
					method: 'POST',
					async: true,
					dataType: 'json',
					data: {
						'ajax': true,
						'action': 'deleteImage',
						'id_image': id
					},
					success: function(data)
					{
						if (data.success) 
						{
							cover = 0;

							if ($("#" + data.id + ' .covered').hasClass('icon-check-sign'))
								cover = 1;
								
							$("#" + data.id).remove();
							
							if (cover)
								$("#imageTable tr").eq(1).find(".covered").addClass('icon-check-sign');
								
							$("#countImage").html(parseInt($("#countImage").html()) - 1);
							
							refreshImagePositions($("#imageTable"));
							showSuccessMessage(data.text);
						}
					}
				});
			}
		});

        $(document).on('click', '.covered', function(e)
		{
			e.preventDefault();
			
			var link = $(this);
			var id = $(link).parent().parent().parent().attr('id');
			
			$.ajax(
			{
				url: currentIndex + '&token=' + token + '&ajax=' + 1,
				method: 'POST',
				async: true,
				dataType: 'json',
				data: {
					'ajax': true,
					'action': 'updateCover',
					'id_image': id,
					'id_album': id_album
				},
				success: function(data)
				{
					if (data.success) 
					{
						refreshCover(link);
						showSuccessMessage(data.text);
					}
					else
						showErrorMessage(data.text);
				}
			});
		});
		
		$(".visible_image").click(function(e)
		{
			e.preventDefault();
			
			var link = $(this);
			var id = $(link).parent().parent().attr('id');
			
			$.ajax(
				{
					url: currentIndex + '&token=' + token + '&ajax=' + 1,
					method: 'POST',
					async: true,
					dataType: 'json',
					data: {
						'ajax': true,
						'action': 'processStatus',
						'id_image': id
					},
					success: function(data)
					{
						if (data.success) 
						{
							refreshVisible(link);
							showSuccessMessage(data.text);
						}
						else
							showErrorMessage(data.text);
					}
				});
			
			return false;
		});
	});
	
	/** 
	 * Drag & Drop zone for upload images 
	 */
	var obj = $("#dragandrophandler");
	
	obj.on('dragenter', function (e)
	{
		e.stopPropagation();
		e.preventDefault();
		$(this).css('opacity', '0.7');
	});
	
	obj.on('dragover', function (e)
	{
		e.stopPropagation();
		e.preventDefault();
	});
	
	obj.on('drop', function (e)
	{
		e.preventDefault();
		$(this).css('opacity', '0.7'); 
		$('.loader').show(); 
		
		var files = e.originalEvent.dataTransfer.files;
		var _this = $(this);

		//We need to send dropped files to Server
		handleFileUpload(files, function()
		{
			$(_this).css('opacity', '1'); 
			$('.loader').hide(); 
		});
	});
	
	$(document).on('change', 'input.fileSelector', function()
	{
		obj.css('opacity', '0.7'); 
		$('.loader').show();
		var _this = $(this);
		
		handleFileUpload(_this.prop('files'), function()
		{
			obj.css('opacity', '1'); 
			$('.loader').hide(); 
		});
	});
	
	$(document).on('click', '.drop-info', function()
	{
		$('input.fileSelector').click();
	});

	function handleFileUpload(files, callback)
	{
		var length = files.length;
		var counter = 0;

		$.each(files, function(index, value)
		{
			var formData = new FormData();
			formData.append('file', files[index]);
			
			$.ajax({
				xhr: function () {
					var xhrobj = $.ajaxSettings.xhr();
					if (xhrobj.upload) {
						xhrobj.upload.addEventListener('progress', function (event) {
							var percent = 0;
							var position = event.loaded || event.position;
							var total = event.total;
							if (event.lengthComputable) {
								percent = Math.ceil(position / total * 100);
							}
						}, false);
					}
					return xhrobj;
				},
				url: uploadURL,
				type: "POST",
				contentType: false,
				processData: false,
				cache: false,
				data: formData,
				success: function (data) {
					data = JSON.parse(data);
					data = data[0];
					
					imageLine(
						data.id,
						img_pub_path + 'thumb_' + data.id + '.jpg',
						data.position,
						data.cover,
						data.description,
						data.active,
						data.date_add
					);
					
					reloadTable();
					$("#countImage").html(parseInt($("#countImage").html()) + 1);
					
					counter++;					
					
					if (counter == length)
						callback();
				}
			});
		});
	}
	
	function updateImagePosition(json)
	{
		$.ajax(
		{
			url: currentIndex + '&token=' + token + '&ajax=' + 1,
			method: 'POST',
			async: true,
			dataType: 'json',
			data: {
				'ajax': true,
				'action': 'imagePosition',
				'json': json
			},
			success: function(data)
			{
				$.cookie("PSHOW_GALLERY_IMAGES_SORTED", 1, { expires : 1, path : '/'});
				if (!data.success) 
					showErrorMessage(data.text);
			}
		});
	}
	
	function reloadTable()
	{
		$("#imageTable").tableDnD(
		{
			dragHandle: 'dragHandle',
			onDragClass: 'myDragClass',
			onDragStart: function(table, row) {
				originalOrder = $.tableDnD.serialize();
				reOrder = ':even';
				if (table.tBodies[0].rows[1] && $('#' + table.tBodies[0].rows[1].id).hasClass('alt_row'))
					reOrder = ':odd';
				$(table).find('#' + row.id).parent('tr').addClass('myDragClass');
			},
			onDrop: function(table, row) {
				if (originalOrder != $.tableDnD.serialize()) {
					current = $(row).attr("id");
					stop = false;
					image_up = "{";
					$("#imageList").find("tr").each(function(i) {
						$("#td_" +  $(this).attr("id")).html('<div class="dragGroup"><div class="positions">'+(i + 1)+'</div></div>');
						if (!stop || (i + 1) == 2)
							image_up += '"' + $(this).attr("id") + '" : ' + (i + 1) + ',';
					});
					image_up = image_up.slice(0, -1);
					image_up += "}";
					updateImagePosition(image_up);
				}
			}
		});
	}
	
	{/literal}
	</script>

<style>
	.icon_sort_up:before {
		content: "\f0d8";
		font-family: "FontAwesome";
		font-style: normal;
		font-size: large;
	}
	.icon_sort_down:before {
		content: "\f0d7";
		font-family: "FontAwesome";
		font-style: normal;
		font-size: large;
	}
	.icon_empty:before {
		content: '\A0';
		font-family: "FontAwesome";
		font-style: normal;
		font-size: large;
	}
	input.editableofocus:not(:focus) {
		border-color: transparent !important;
		background: transparent !important;
	}
	input.fileSelector {
		display: none !important;
	}
	#dragandrophandler {
		position: relative;
	}
	.drop-info {
		font-weight: bold;
		font-size: 16px;
		color: darkgray;
		text-align: center;
		height: 100px;
		padding: 25px 15px 0;
		margin-bottom: 20px;
		border: 2px dashed #A9A9A9;
		border-radius: 5px;
		cursor: pointer;
    }
	.loader {
		display: none;
		position: absolute;
		top: 20px;
		left: 50%;
		margin-left: -30px;
		width: 60px;
		height: 60px;
		background: url(../modules/pshowgallery/views/img/loader.svg);
	}
	.gallery_thumb {
		position: relative;
		height: 66px !important;
		width: 100%;
		background-size: contain;
		background-repeat: no-repeat;
	}
	.gallery_thumb img {
		display: none;
	}
	.gallery_thumb:hover img {
		display: block;
		position: absolute;
		z-index: 10;
		bottom: 0;
		left: 0;
		height: 300px;
		width: 300px;
		padding: 4px;
		border: 1px solid #ddd;
		background: #fff;
	}
</style>
