<?php

/**
 * File from http://PrestaShow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 * @authors     PrestaShow.pl <kontakt@prestashow.pl>
 * @copyright   2016 PrestaShow.pl
 * @license     http://PrestaShow.pl/license
 */

namespace Prestashow\PShowGallery\Entity;

use Configuration;
use Db;
use ObjectModel;
use Prestashow\PrestaCore\Model\AbstractEntity;

class PShowGalleryImage extends AbstractEntity
{
    /** @var integer image ID */
    public $id_pshow_gallery_image;

    /** @var integer album ID */
    public $id_album;

    /** @var string ext */
    public $extension;

    /** @var integer position */
    public $position;

    /** @var string desc */
    public $description;

    /** @var string Object creation date */
    public $date_add;

    /** @var string Object last modification date */
    public $date_upd;

    /** @var bool visible */
    public $active;

    /** @var bool visible */
    public $cover;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'pshow_gallery_image',
        'primary' => 'id_pshow_gallery_image',
        'multilang' => true,
        'multilang_shop' => false,
        'fields' => array(
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'id_album' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'extension' => array('type' => self::TYPE_STRING, 'size' => 10),
            'position' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'active' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'required' => true),
            'cover' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            /* Lang fields */
            'description' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCatalogName')
        )
    );

    public function __construct($id_album = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id_album, $id_lang, $id_shop);
    }

    public static function getImagesCount($id_lang, $id_album, $active = true)
    {
        $q = "SELECT COUNT(*) as total FROM `" . _DB_PREFIX_ . "pshow_gallery_image` c
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_image_lang` cl ON (
                cl.`id_pshow_gallery_image` = c.`id_pshow_gallery_image` AND
                cl.`id_lang` = " . (int)$id_lang . "
            )
            WHERE c.`id_album` = " . (int)$id_album;

        if ($active) {
            $q .= " AND c.`active` = 1";
        }

        return Db::getInstance()->getValue($q);
    }

    public static function getImage($id_lang, $id_image)
    {
        $q = "SELECT * FROM `" . _DB_PREFIX_ . "pshow_gallery_image` c
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_image_lang` cl ON (
                cl.`id_pshow_gallery_image` = c.`id_pshow_gallery_image` AND
                cl.`id_lang` = " . (int)$id_lang . "
            )
            WHERE c.`id_pshow_gallery_image` = " . (int)$id_image
            . " AND c.`active` = 1";

        return Db::getInstance()->query($q);
    }

    public static function getAllImages($id_lang)
    {
        if (isset($_COOKIE["PSHOW_GALLERY_IMAGES_SORTED"])) {
            Configuration::updateValue('PSHOW_GALLERY_IMAGES_SORTED', $_COOKIE["PSHOW_GALLERY_IMAGES_SORTED"]);
        }

        if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_DATA_ASC) {
            $sort = "`date_add` ASC";
        } else if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_DATA_DESC) {
            $sort = "`date_add` DESC";
        } else if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_POSITION_ASC) {
            $sort = "`position` ASC";
        } else if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_POSITION_DESC) {
            $sort = "`position` DESC";
        } else {
            $sort = "`position` ASC";
        }
        $q = "SELECT * FROM `" . _DB_PREFIX_ . "pshow_gallery_image` c
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_image_lang` cl ON (
                cl.`id_pshow_gallery_image` = c.`id_pshow_gallery_image` AND
                cl.`id_lang` = " . (int)$id_lang . "
            )";

        $q .= " ORDER BY c." . $sort;

        return Db::getInstance()->executeS($q);
    }

    public static function getImages($id_lang, $id_album, $active = true, $limit = 0): array
    {
        if (isset($_COOKIE["PSHOW_GALLERY_IMAGES_SORTED"])) {
            Configuration::updateValue('PSHOW_GALLERY_IMAGES_SORTED', $_COOKIE["PSHOW_GALLERY_IMAGES_SORTED"]);
        }

        if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_DATA_ASC) {
            $sort = "`date_add` ASC";
        } else if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_DATA_DESC) {
            $sort = "`date_add` DESC";
        } else if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_POSITION_ASC) {
            $sort = "`position` ASC";
        } else if (Configuration::get('PSHOW_GALLERY_IMAGES_SORTED') == PSHOW_GALLERY_IMAGES_SORTED_BY_POSITION_DESC) {
            $sort = "`position` DESC";
        } else {
            $sort = "`position` ASC";
        }
        $q = "SELECT * FROM `" . _DB_PREFIX_ . "pshow_gallery_image` c
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_image_lang` cl ON (
                cl.`id_pshow_gallery_image` = c.`id_pshow_gallery_image` AND
                cl.`id_lang` = " . (int)$id_lang . "
            )
			WHERE c.`id_album` = " . (int)$id_album;

        if ($active)
            $q .= " AND c.`active` = 1";

        $q .= " ORDER BY c." . $sort;

        if ($limit > 0) {
            $q .= " LIMIT " . (int)$limit;
        }

        return Db::getInstance()->executeS($q);
    }

    public static function getCoverId($id_album)
    {
        $q = "SELECT c.`id_pshow_gallery_image` FROM `" . _DB_PREFIX_ . "pshow_gallery_image` c
			WHERE c.`id_album` = " . (int)$id_album . " AND c.`cover` = 1";

        return Db::getInstance()->getValue($q);
    }

    public static function deleteCovers($id_album)
    {
        $q = "UPDATE `" . _DB_PREFIX_ . "pshow_gallery_image`
			SET `cover` = 0 WHERE `id_album` = " . (int)$id_album;

        return Db::getInstance()->query($q);
    }

    public static function countImages($id_album, $active = true)
    {
        $q = "SELECT COUNT(*)
            FROM `" . _DB_PREFIX_ . "pshow_gallery_image` c
			
			WHERE c.`id_album` = " . (int)$id_album;

        if ($active)
            $q .= " AND c.`active` = 1";

        $query = Db::getInstance()->getValue($q);

        if ($query === false)
            return false;

        return $query;
    }

    public function add($autodate = true, $null_values = false)
    {
        return parent::add($autodate, $null_values);
    }

    public function update($null_values = false)
    {
        return parent::update($null_values);
    }
}
