<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * @since 1.5.0
 */

class hotpayPRZELEWYValidationModuleFrontController extends ModuleFrontController
{
    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {
        $cart = $this->context->cart;
        if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        // Check that this payment option is still available in case the customer changed his address just before the end of the checkout process
        $authorized = false;
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'hotpayPRZELEWY') {
                $authorized = true;
                break;
            }
        }

        if (!$authorized) {
            die($this->module->l('This payment method is not available.', 'validation'));
        }

        $this->context->smarty->assign([
            'params' => $_REQUEST,
        ]);


$customer = new Customer($cart->id_customer);
$amountToBePaid = $cart->getOrderTotal(true, Cart::BOTH);
$order_status = (int)Configuration::get('PS_OS_CHEQUE');
$this->module->validateOrder($cart->id, $order_status, $amountToBePaid, "Hotpay Przelewy", null, array(), null, false, $cart->secure_key);
$id_order = Order::getOrderByCartId($cart->id);

                echo '
<form id="order_hotpayPRZELEWY" action="https://platnosc.hotpay.pl/" method="post">
<input required name="SEKRET" value="'.Configuration::get('hotpayPRZELEWY_SEKRET').'" type="hidden">
<input required name="KWOTA" value="'.$amountToBePaid.'" type="hidden">
<input required name="NAZWA_USLUGI" value="Zamówienie nr:'. $cart->id . " w " . Configuration::get('PS_SHOP_NAME').'" type="hidden">
<input required name="ADRES_WWW" value="'.Tools::getHttpHost(true).__PS_BASE_URI__. 'index.php?controller=order-confirmation&id_cart=' . $cart->id .'&id_module='. $this->id .'&id_order=' . $id_order . '&key=' . $cart->secure_key.'" type="hidden">
<input required name="ID_ZAMOWIENIA" value="'.$cart->id.'" type="hidden">
<input name="EMAIL" value="'.$customer->email.'" type="hidden">
<input name="DANE_OSOBOWE" value="'.$customer->firstname." ".$customer->lastname.'" type="hidden">
<center><button type="submit">Zapłać teraz</button></center>
</form>    
<script type="text/javascript">
    window.onload=function(){
       document.forms["order_hotpayPRZELEWY"].submit();
    }
</script> 
        ';



    }
}


