<?php

/**
 * File from https://prestashow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 * @authors     PrestaShow.pl <kontakt@prestashow.pl>
 * @copyright   2020 PrestaShow.pl
 * @license     https://prestashow.pl/license
 */

namespace Prestashow\PShowGallery\Controller;

use Prestashow\PrestaCore\Model\AbstractAdminController;
use Prestashow\PShowGallery\Entity\PShowGalleryImage;
use Prestashow\PShowGallery\Model\Module as PShowGallery;
use Tools;
use Context;
use Language;
use Configuration;
use ImageManager;

class IndexController extends AbstractAdminController {

    public $default_action = 'list';
    public $select_menu_tab = 'subtab-PShowGalleryMain';
    
    public function __construct()
    {
        $this->table = 'pshow_gallery_configuration';
        $this->context = Context::getContext();
        
        parent::__construct();
        
        $this->controller_displayName = $this->l('Settings');
        $this->toolbar_title = $this->l('Settings');
        
        $this->display = $this->default_action;
        
        $this->tpl_folder = 'gallerymain/';
    }
    
    public function postProcess()
    {
        if (Tools::isSubmit('submitSaveConfiguration'))
        {
            $languages = Language::getLanguages();
            $result = array();
            foreach ($languages as $lang) {
                $result['page_name'][$lang['id_lang']] = Tools::getValue('page_name_'. $lang['id_lang']);
            }
            
            $size_of_thumbnails = Tools::getValue('size_of_thumbnails');
            Configuration::updateValue('PSHOW_GALLERY_SIMPLE_SHOW', Tools::getValue('simple_show'));
            Configuration::updateValue('PSHOW_GALLERY_SIZE_OF_THUMBNAILS', $size_of_thumbnails);
            Configuration::updateValue('PSHOW_GALLERY_WIDTH_THUMBNAIL', ($size_of_thumbnails == PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_WIDTH ? Tools::getValue('width_thumbnail') : 300));
            Configuration::updateValue('PSHOW_GALLERY_HEIGHT_THUMBNAIL', ($size_of_thumbnails == PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_HEIGHT ? Tools::getValue('height_thumbnail') : 225));
            Configuration::updateValue('PSHOW_GALLERY_SHARE_SHOW', Tools::getValue('share_show'));
            Configuration::updateValue('PSHOW_GALLERY_RIGHT_COLUMN', Tools::getValue('right_column'));
            Configuration::updateValue('PSHOW_GALLERY_PAGE_NAME', $result['page_name']);
            Configuration::updateValue('PSHOW_GALLERY_SEO_KEYWORD', Tools::getValue('seo_keyword'));
            Configuration::updateValue('PSHOW_GALLERY_PRODUCT_PAGE_ASSOCIATIONS', Tools::getValue('product_tags_associations'));
            Configuration::updateValue('PSHOW_GALLERY_CATEGORY_PAGE_ASSOCIATIONS', Tools::getValue('category_tags_associations'));
            Configuration::updateValue('PSHOW_GALLERY_CMS_PAGE_ASSOCIATIONS', Tools::getValue('cms_tags_associations'));
            $this->regenerateThumbnails();
        }
    }
    
    public function renderList()
    {
        return $this->renderForm();
    }
    
    public function renderForm()
    {
        $this->action_displayName = $this->l('Settings');
        
        $active_input_type = 'switch';
        $prefix_type = 'prefix';
        if (version_compare(_PS_VERSION_, '1.6', '<'))
            $active_input_type = 'radio';
            
            $this->fields_form = array(
                'tinymce' => true,
                'legend' => array(
                    'title' => $this->l('Settings')
                ),
                'input' => array(
                    array(
                        'type' => $active_input_type,
                        'label' => $this->l('Simple gallery show'),
                        'hint' => $this->l('If enabled displays album in pop-up box, otherwise opens new page'),
                        'name' => 'simple_show',
                        'class' => 't',
                        'is_bool' => true,
                        'default_value' => false,
                        'values' => array(
                            array(
                                'id' => 'right_column_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'right_column_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Size of thumbnails'),
                        'name' => 'size_of_thumbnails',
                        'required' => true,
                        'options' => array(
                            'query' => array(
                                array(
                                    'id' => PShowGallery::PSHOW_SIZE_OF_THUMB_DEFAULT,
                                    'name' => $this->l('Default size')
                                ),
                                array(
                                    'id' => PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_WIDTH,
                                    'name' => $this->l('Own width')
                                ),
                                array(
                                    'id' => PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_HEIGHT,
                                    'name' => $this->l('Own height')
                                )
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Width'),
                        'name' => 'width_thumbnail',
                        'col' => 2,
                        'size' => 10,
                        'default_value' => '300',
                        $prefix_type => 'px',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Height'),
                        'name' => 'height_thumbnail',
                        'col' => 2,
                        'size' => 10,
                        'default_value' => '225',
                        $prefix_type => 'px',
                    ),
                    array(
                        'type' => $active_input_type,
                        'label' => $this->l('Share buttons'),
                        'hint' => $this->l('If enabled displays share buttons under image'),
                        'name' => 'share_show',
                        'class' => 't',
                        'is_bool' => true,
                        'default_value' => false,
                        'values' => array(
                            array(
                                'id' => 'share_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'share_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        )
                    ),
                    array(
                        'type' => $active_input_type,
                        'label' => $this->l('Display right column'),
                        'hint' => $this->l('Shows or hides the right column in the template while you are browsing gallery'),
                        'name' => 'right_column',
                        'class' => 't',
                        'is_bool' => true,
                        'default_value' => false,
                        'values' => array(
                            array(
                                'id' => 'right_column_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'right_column_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Page name (meta title)'),
                        'name' => 'page_name',
                        'required' => true,
                        'lang' => true,
                        'size' => 48,
                        'hint' => $this->l('Invalid characters:').' &lt;&gt;;=#{}'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Seo keyword'),
                        'name' => 'seo_keyword',
                        'required' => true,
                        'hint' => $this->l('Only letters and the minus (-) character are allowed.')
                    ),
                    array(
                        'type' => $active_input_type,
                        'label' => $this->l('Enable associations of albums with pages of products by tags'),
                        'name' => 'product_tags_associations',
                        'class' => 't',
                        'is_bool' => true,
                        'default_value' => true,
                        'values' => array(
                            array(
                                'id' => 'product_tags_associations_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'product_tags_associations_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        )
                    ),
                    array(
                        'type' => $active_input_type,
                        'label' => $this->l('Enable associations of albums with pages of categories by tags'),
                        'name' => 'category_tags_associations',
                        'class' => 't',
                        'is_bool' => true,
                        'default_value' => true,
                        'values' => array(
                            array(
                                'id' => 'category_tags_associations_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'category_tags_associations_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        )
                    ),
                    array(
                        'type' => $active_input_type,
                        'label' => $this->l('Enable associations of albums with pages of cms by tags'),
                        'name' => 'cms_tags_associations',
                        'class' => 't',
                        'is_bool' => true,
                        'default_value' => true,
                        'values' => array(
                            array(
                                'id' => 'cms_tags_associations_on',
                                'value' => 1,
                                'label' => $this->l('Enabled')
                            ),
                            array(
                                'id' => 'cms_tags_associations_off',
                                'value' => 0,
                                'label' => $this->l('Disabled')
                            )
                        )
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                    'name' => 'submitSaveConfiguration',
                    'class' => 'btn btn-success'
                )
            );
            
            $this->fields_value = $this->getConfiguration();
            
            unset($this->toolbar_btn['back'], $this->toolbar_btn['new']);
            
            return parent::renderForm();
    }
    
    public function regenerateThumbnails() {
        $img_dir = _PS_IMG_DIR_ . PShowGallery::GALLERY_IMAGE;
        $images = PShowGalleryImage::getAllImages($this->context->language->id);
        foreach ($images as $image)
        {
            $upload_path = $image['id_pshow_gallery_image'] . '.' . $image['extension'];
            $data = getimagesize($img_dir . $upload_path);
            $size_of_thumbnails = Configuration::get('PSHOW_GALLERY_SIZE_OF_THUMBNAILS');
            
            $x = $data[0];
            $y = $data[1];
            if($size_of_thumbnails && $size_of_thumbnails == PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_WIDTH )
            {
                $default_width = (Configuration::get('PSHOW_GALLERY_WIDTH_THUMBNAIL') ? Configuration::get('PSHOW_GALLERY_WIDTH_THUMBNAIL') : 300);
                
                $percentage = ((($x >= $default_width ? $x - $default_width : $default_width - $x) * 100) / $x);
                $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                ImageManager::resize($img_dir . $upload_path, $img_dir . 'thumb_' . $image['id_pshow_gallery_image'] . '.jpg', $default_width, $height, 'jpg');
            }
            else if($size_of_thumbnails && $size_of_thumbnails == PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_HEIGHT )
            {
                $x = $data[1];
                $y = $data[0];
                $default_height = (Configuration::get('PSHOW_GALLERY_HEIGHT_THUMBNAIL') ? Configuration::get('PSHOW_GALLERY_HEIGHT_THUMBNAIL') : 225);
                
                $percentage = ((($x >= $default_height ? $x - $default_height : $default_height - $x) * 100) / $x);
                $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                ImageManager::resize($img_dir . $upload_path, $img_dir . 'thumb_' . $image['id_pshow_gallery_image'] . '.jpg', $height, $default_height, 'jpg');
            }
            else
            {
                if($data[0] >= $data[1])
                {
                    $default_width = 300;
                    
                    $percentage = ((($x >= $default_width ? $x - $default_width : $default_width - $x) * 100) / $x);
                    $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                    ImageManager::resize($img_dir . $upload_path, $img_dir . 'thumb_' . $image['id_pshow_gallery_image'] . '.jpg', $default_width, $height, 'jpg');
                }
                else
                {
                    $x = $data[1];
                    $y = $data[0];
                    
                    $default_height = 225;
                    
                    $percentage = ((($x >= $default_height ? $x - $default_height : $default_height - $x) * 100) / $x);
                    $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                    ImageManager::resize($img_dir . $upload_path, $img_dir . 'thumb_' . $image['id_pshow_gallery_image'] . '.jpg', $height, $default_height, 'jpg');
                }
            }
        }
    }
    
    public function getConfiguration()
    {
        $fields = array(
            'simple_show' => Tools::getValue('PSHOW_GALLERY_SIMPLE_SHOW', Configuration::get('PSHOW_GALLERY_SIMPLE_SHOW')),
            'size_of_thumbnails' => Tools::getValue('PSHOW_GALLERY_SIZE_OF_THUMBNAILS', Configuration::get('PSHOW_GALLERY_SIZE_OF_THUMBNAILS')),
            'width_thumbnail' => Tools::getValue('PSHOW_GALLERY_WIDTH_THUMBNAIL', Configuration::get('PSHOW_GALLERY_WIDTH_THUMBNAIL')),
            'height_thumbnail' => Tools::getValue('PSHOW_GALLERY_HEIGHT_THUMBNAIL', Configuration::get('PSHOW_GALLERY_HEIGHT_THUMBNAIL')),
            'share_show' => Tools::getValue('PSHOW_GALLERY_SHARE_SHOW', Configuration::get('PSHOW_GALLERY_SHARE_SHOW')),
            'right_column' => Tools::getValue('PSHOW_GALLERY_RIGHT_COLUMN', Configuration::get('PSHOW_GALLERY_RIGHT_COLUMN')),
            'seo_keyword' => Tools::getValue('PSHOW_GALLERY_SEO_KEYWORD', Configuration::get('PSHOW_GALLERY_SEO_KEYWORD')),
            'product_tags_associations' => Tools::getValue('PSHOW_GALLERY_PRODUCT_PAGE_ASSOCIATIONS', Configuration::get('PSHOW_GALLERY_PRODUCT_PAGE_ASSOCIATIONS')),
            'category_tags_associations' => Tools::getValue('PSHOW_GALLERY_CATEGORY_PAGE_ASSOCIATIONS', Configuration::get('PSHOW_GALLERY_CATEGORY_PAGE_ASSOCIATIONS')),
            'cms_tags_associations' => Tools::getValue('PSHOW_GALLERY_CMS_PAGE_ASSOCIATIONS', Configuration::get('PSHOW_GALLERY_CMS_PAGE_ASSOCIATIONS'))
        );
        
        $languages = Language::getLanguages(false);
        foreach ($languages as $lang) {
            $fields['page_name'][$lang['id_lang']] = Tools::getValue('PSHOW_GALLERY_PAGE_NAME', Configuration::get('PSHOW_GALLERY_PAGE_NAME', $lang['id_lang']));
        }
        
        return $fields;
    }
    
    // Temporary bypass functions
    public function listHelperAction() {}
}
