<?php

/**
 * File from http://PrestaShow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 *  @authors     PrestaShow.pl <kontakt@prestashow.pl>
 *  @copyright   2016 PrestaShow.pl
 *  @license     http://PrestaShow.pl/license
 */

namespace Prestashow\PShowGallery\Controller;

use Prestashow\PrestaCore\Model\AbstractAdminController;
use Prestashow\PShowGallery\Entity\PShowGalleryAlbum;
use Prestashow\PShowGallery\Entity\PShowGalleryImage;
use Prestashow\PShowGallery\Model\Module as PShowGallery;
use Db;
use Language;
use Tools;
use Configuration;
use Validate;
use ImageManager;

class ImageController extends AbstractAdminController
{
    public $default_action = 'index';
    public $select_menu_tab = 'subtab-PShowGalleryImage';
    
    public function __construct()
    {
        $this->table = 'pshow_gallery_image';
        
        parent::__construct();
        
        $this->id_album = (int) Tools::getValue('id_pshow_gallery_album');
        
        $this->id_shop = (int) $this->context->shop->id;
        $this->id_lang = (int) $this->context->cookie->id_lang;
        
        $this->controller_displayName = $this->l('Images list');
        
        $this->img_dir = _PS_IMG_DIR_ . PShowGallery::GALLERY_IMAGE;
        $this->img_pub_path = _PS_IMG_ . PShowGallery::GALLERY_IMAGE;
        $this->supported_ext = array('jpg', 'jpeg', 'png', 'bmp', 'gif');
        
        $this->context->smarty->assign('img_pub_path', $this->img_pub_path);
        $this->context->smarty->assign('id_pshow_gallery_album', $this->id_album);
    }
    
    public function postProcess()
    {
        $this->addjQueryPlugin(array(
            'tablednd',
            'ajaxfileupload'
        ));
        
        $this->addJS(array(
            _PS_JS_DIR_.'fileuploader.js',
            _PS_JS_DIR_.'admin-dnd.js'
        ));
        
        if (Tools::getValue('ajax'))
        {
            if (Tools::getValue('action') == 'imagePosition')
                $this->ajaxImagePosition();
                
                else if (Tools::getValue('action') == 'updateCover')
                    $this->ajaxUpdateCover();
                    
                    else if (Tools::getValue('action') == 'processStatus')
                        $this->ajaxProcessStatus();
                        
                        else if (Tools::getValue('action') == 'deleteImage')
                            $this->ajaxDeleteImage();
                            
                            else if (Tools::getValue('action') == 'description')
                                $this->ajaxDescription();
        }
    }
    
    public function ajaxImagePosition()
    {
        $res = false;
        
        if ($json = Tools::getValue('json'))
        {
            $res = true;
            $json = stripslashes($json);
            $images = Tools::jsonDecode($json, true);
            print_r($images);
            foreach ($images as $id_image => $position)
            {
                $image = new PShowGalleryImage((int) $id_image);
                $image->position = (int)$position;
                $res &= $image->save();
            }
        }
        
        $res ?
        die(Tools::jsonEncode(array('success' => true))) :
        die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('An error occurred while attempting to move this picture.'))));
    }
    
    public function ajaxUpdateCover()
    {
        PShowGalleryImage::deleteCovers(Tools::getValue('id_album'));
        $image = new PShowGalleryImage((int) Tools::getValue('id_image'));
        $image->cover = 1;
        
        $image->save() ?
        die(Tools::jsonEncode(array('success' => true, 'text' => $this->l('Album cover has been updated successfully')))) :
        die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('Failed to update the cover'))));
    }
    
    public function ajaxProcessStatus()
    {
        if (!$id_image = (int)Tools::getValue('id_image'))
            die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('Failed to update the status'))));
            else
            {
                $image = new PShowGalleryImage((int)$id_image);
                if (Validate::isLoadedObject($image))
                {
                    $image->active = $image->active == 1 ? 0 : 1;
                    $image->save() ?
                    die(Tools::jsonEncode(array('success' => true, 'text' => $this->l('The status has been updated successfully')))) :
                    die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('Failed to update the status'))));
                }
            }
    }
    
    public function ajaxDeleteImage()
    {
        $id_image = (int) Tools::getValue('id_image');
        $image = new PShowGalleryImage($id_image);
        $id_album = $image->id_album;
        $res = false;
        
        if ($id_image > 0 && Validate::isLoadedObject($image))
        {
            @unlink($this->img_dir . $image->id . '.' . $image->extension);
            @unlink($this->img_dir . 'thumb_' . $image->id . '.jpg');
            
            $res = $image->delete();
            
            // if deleted image was the cover, change it to the first one
            if (!PShowGalleryImage::getCoverId($id_album))
            {
                $sql = 'UPDATE `' . _DB_PREFIX_ . $this->table .'` i
				SET i.`cover` = 1
				WHERE i.`id_album` = ' . (int) $id_album . '
				ORDER BY i.`position` ASC
				LIMIT 1';
                
                $res &= Db::getInstance()->execute($sql);
            }
        }
        
        $res ?
        die(Tools::jsonEncode(array('success' => true, 'id' => $id_image, 'text' => $this->l('Image removed.')))) :
        die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('An error occurred while attempting to delete image.'))));
    }
    
    public function ajaxDescription()
    {
        $res = false;
        $id_image = (int) Tools::getValue('id_image');
        $description = Tools::getValue('description');
        $description = stripslashes($description);
        $description = Tools::jsonDecode($description, true);
        
        if ($id_image > 0 && is_object($image = new PShowGalleryImage($id_image)))
        {
            $languages = Language::getLanguages(true);
            
            foreach ($languages as $lang)
            {
                $val = $description[$lang['id_lang']];
                $image->description[$lang['id_lang']] = (($val) ? $val : '');
            }
            
            $res = $image->update();
        }
        
        $res ?
        die(Tools::jsonEncode(array('success' => true, 'text' => $this->l('Image description modified.')))) :
        die(Tools::jsonEncode(array('success' => false, 'error' => true, 'text' => $this->l('An error occurred while updating image.'))));
    }
    
    public function indexAction()
    {
        $this->action_displayName = $this->l('Images list');
        
        $images_ = PShowGalleryImage::getImages($this->id_lang, $this->id_album, false);
        $imagesCount = PShowGalleryImage::countImages($this->id_album, false);
        
        $images = array();
        foreach ($images_ as $key => $image)
        {
            $images[$key] = new PShowGalleryImage($image['id_pshow_gallery_image']);
        }
        
        $languages = Language::getLanguages(true);
        $update_url = 'http://' . $_SERVER['SERVER_NAME'] . str_replace('index.php', '', $_SERVER['PHP_SELF']) . $this->context->link->getAdminLink('PShowGalleryImage') . "&page=editimage";
        
        $this->context->smarty->assign('update_url', $update_url);
        $this->context->smarty->assign('languages', $languages);
        $this->context->smarty->assign('default_language', Configuration::get('PS_LANG_DEFAULT'));
        $this->context->smarty->assign('album', new PShowGalleryAlbum($this->id_album));
        $this->context->smarty->assign('images', $images);
        $this->context->smarty->assign('imagesCount', $imagesCount);
    }
    
    public function uploadFile($isArray, $i)
    {
        $languages = Language::getLanguages(true);
        
        if ($isArray)
        {
            $filename = $_FILES['file']['name'][$i];
            $tmpname = $_FILES['file']['tmp_name'][$i];
        }
        else
        {
            $filename = $_FILES['file']['name'];
            $tmpname = $_FILES['file']['tmp_name'];
        }
        
        $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (!in_array($extension, $this->supported_ext))
        {
            $this->alerts[] = array('warning', $this->l('Wrong extension, supported: '). implode(", ", $this->supported_ext));
            return;
        }
        
        $image = new PShowGalleryImage();
        
        $image->description = array();
        $image->extension = $extension;
        $image->id_album = Tools::getValue('id_album');
        $image->active = 1;
        $image->position = 0;
        
        $q = "SELECT c.`position`
            FROM `" . _DB_PREFIX_ . "pshow_gallery_image` c
            WHERE c.`id_album` = " . $image->id_album . "
            ORDER BY c.`position` DESC";
        
        $image->position = (int) Db::getInstance()->getValue($q);
        
        // if there no images set first to cover of album
        if (!$image->position)
            $image->cover = 1;
            
            $image->position++;
            
            foreach ($languages as $lang)
            {
                $val = Tools::getValue('description_' . $lang['id_lang']);
                $image->description[$lang['id_lang']] = (($val) ? $val : '');
            }
            
            if ($image->add())
            {
                if (!file_exists($this->img_dir))
                    mkdir($this->img_dir, 0777, true);
                    
                    $upload_path = $image->id . '.' . $extension;
                    
                    if (!move_uploaded_file($tmpname, $this->img_dir . $upload_path))
                    {
                        $this->alerts[] = array('warning', $this->l('An error occurred while uploading the file'));
                        $image->delete();
                        return;
                    }
                    else
                    {
                        $data = getimagesize($this->img_dir . $upload_path);
                        $size_of_thumbnails = Configuration::get('PSHOW_GALLERY_SIZE_OF_THUMBNAILS');
                        
                        $x = $data[0];
                        $y = $data[1];
                        if($size_of_thumbnails && $size_of_thumbnails == PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_WIDTH )
                        {
                            $default_width = (Configuration::get('PSHOW_GALLERY_WIDTH_THUMBNAIL') ? Configuration::get('PSHOW_GALLERY_WIDTH_THUMBNAIL') : 300);
                            
                            $percentage = ((($x >= $default_width ? $x - $default_width : $default_width - $x) * 100) / $x);
                            $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                            ImageManager::resize($this->img_dir . $upload_path, $this->img_dir . 'thumb_' . $image->id . '.jpg', $default_width, $height, 'jpg');
                        }
                        else if($size_of_thumbnails && $size_of_thumbnails == PShowGallery::PSHOW_SIZE_OF_THUMB_OWN_HEIGHT )
                        {
                            $x = $data[1];
                            $y = $data[0];
                            $default_height = (Configuration::get('PSHOW_GALLERY_HEIGHT_THUMBNAIL') ? Configuration::get('PSHOW_GALLERY_HEIGHT_THUMBNAIL') : 225);
                            
                            $percentage = ((($x >= $default_height ? $x - $default_height : $default_height - $x) * 100) / $x);
                            $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                            ImageManager::resize($this->img_dir . $upload_path, $this->img_dir . 'thumb_' . $image->id . '.jpg', $height, $default_height, 'jpg');
                        }
                        else
                        {
                            if($data[0] >= $data[1])
                            {
                                $default_width = 300;
                                
                                $percentage = ((($x >= $default_width ? $x - $default_width : $default_width - $x) * 100) / $x);
                                $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                                ImageManager::resize($this->img_dir . $upload_path, $this->img_dir . 'thumb_' . $image->id . '.jpg', $default_width, $height, 'jpg');
                            }
                            else
                            {
                                $x = $data[1];
                                $y = $data[0];
                                
                                $default_height = 225;
                                
                                $percentage = ((($x >= $default_height ? $x - $default_height : $default_height - $x) * 100) / $x);
                                $height = ($percentage >= 100 ? $y + ($y * ($percentage / 100)) : $y - ($y * ($percentage / 100)));
                                ImageManager::resize($this->img_dir . $upload_path, $this->img_dir . 'thumb_' . $image->id . '.jpg', $height, $default_height, 'jpg');
                            }
                        }
                        
                        @chmod($this->img_dir . $upload_path, 0664);
                    }
                    
                    die(Tools::jsonEncode(array($image)));
            }
            else
                $this->alerts[] = array('warning', $this->l('Image saving error, try again'));
    }
    
    public function addimageAction()
    {
        if (isset($_FILES['file']['name']))
        {
            if (!is_array($_FILES['file']['name']))
                $this->uploadFile(false, 0);
                else
                    for ($i = 0; $i < count($_FILES['file']['name']); ++$i)
                        $this->uploadFile(true, $i);
        }
    }
}
