<?php
 
 class CmsController extends CmsControllerCore
{
	/*
    * module: pshowgallery
    * date: 2021-07-26 23:31:28
    * version: 2.31.0
    */
    public function initContent()
	{
		parent::initContent();
		if(Module::isEnabled('pshowgallery') && Validate::isLoadedObject($this->cms)) {
			$this->cms->content = PShowGallery::getHooksFromContent($this->cms->content);
			$this->context->smarty->assign('cms', $this->cms);
			if(version_compare(_PS_VERSION_, '1.7.0', '>='))
			{
				$cmsVar = $this->objectPresenter->present($this->cms);
				
				$filteredCmsContent = Hook::exec(
						'filterCmsContent',
						array('object' => $cmsVar),
						$id_module = null,
						$array_return = false,
						$check_exceptions = true,
						$use_push = false,
						$id_shop = null,
						$chain = true
						);
				if (!empty($filteredCmsContent['object'])) {
					$cmsVar = $filteredCmsContent['object'];
				}
				
				$this->context->smarty->assign(array(
						'cms' => $cmsVar,
				));
			}
			else
			{
				$this->context->smarty->assign('cms', $this->cms);
			}
		}
	}
}
