<?php
require_once dirname(__FILE__) . "/../../config.php";
use Prestashow\PShowGallery\Entity\PShowGalleryAlbum;
use Prestashow\PShowGallery\Model\Module as PShowGallery;
use Configuration;
class PShowGalleryAlbumModuleFrontController extends ModuleFrontController
{
    public $album;
    public function init()
    {
        parent::init();
        $this->display_column_right = Configuration::get('PSHOW_GALLERY_RIGHT_COLUMN');
        if ($id_album = (int)Tools::getValue('id')) {
            $this->album = new PShowGalleryAlbum($id_album, $this->context->language->id, $this->context->shop->id);
        }
        if (!Validate::isLoadedObject($this->album) || !$this->album->active) {
            $this->redirect_after = '404';
            $this->redirect();
        } else {
            PShowGallery::canonicalRedirection(PShowGallery::getAlbumLink($this->album->id_pshow_gallery_album));
        }
    }
    public function setMedia()
    {
        parent::setMedia();
        $this->addJqueryPlugin('fancybox');
    }
    public function initContent()
    {
        parent::initContent();
        if (!$this->errors) {
            $ssl = Configuration::get('PS_SSL_ENABLED');
            $base = ($ssl ? 'https://' . $this->context->shop->domain_ssl : 'http://' . $this->context->shop->domain);
            $img_pub_path = $base . _PS_IMG_ . PShowGallery::GALLERY_IMAGE;
            $mobile_device = $this->context->getMobileDevice();
            $this->context->smarty->assign(array(
                'meta_title' => strip_tags($this->album->name),
                'album' => $this->album,
                'albums' => PShowGalleryAlbum::getAlbums($this->context->language->id, $this->context->shop->id, true),
                'images' => $this->album->getImages(),
                'img_pub_path' => $img_pub_path,
                'mobile_device' => $mobile_device
            ));
        }
        $pipe = Configuration::get('PS_NAVIGATION_PIPE');
        if (empty($pipe)) {
            $pipe = '>';
        }
        $this->context->smarty->assign('path',
            '<a href="' . PShowGallery::getAlbumLink() . '">' . Configuration::get('PSHOW_GALLERY_PAGE_NAME', $this->context->language->id) . '</a>' .
            (!$this->errors ? '<span class="navigation-pipe">' . $pipe . '</span> ' . $this->album->name : '')
        );
        if (version_compare(_PS_VERSION_, '1.7.0', '>=')) {
            $this->setTemplate('module:pshowgallery/views/templates/front/album_new_presta.tpl');
        } else {
            $this->setTemplate('album.tpl');
        }
    }
}
