$(document).ready(function (keyframes, options) {

    let albumSingleItemWidth;
    let albumListWidth;
    let albumScrollerWidth;

    var clicked = false, clickX;

    $('.album-scroller').on({
        'mousemove': function (e) {
            clicked && updateScrollPos(e);
        },
        'mousedown': function (e) {
            clicked = true;
            clickX = e.pageX;
            $('.album-scroller').addClass('blockSelection');
        },
        'mouseup': function () {
            clicked = false;
            $('.album-scroller').removeClass('blockSelection');
        }
    });

    var updateScrollPos = function (e) {
        $('.album-scroller').scrollLeft($('.album-scroller').scrollLeft() + (clickX - e.pageX));
    }

    // scroll left event in album list
    $('section.album-list .right-arrow-container > i').on('click', function () {
        $('.album-scroller').animate({
            scrollLeft: "+=300px"
        }, "slow");
    });

    // scroll right event in album list
    $('section.album-list .left-arrow-container > i').on('click', function () {
        $('.album-scroller').animate({
            scrollLeft: "-=300px"
        }, "slow");
    });

    // album item anchor
    $('.album-item').on('click', function (e) {
        window.location.href = $(this).find('.album-front-img a').attr('href');
    });

    // back to the album list anchor
    $('.get-back-to-albums-container').on('click', function (e) {
        window.location.href = $(this).find('a').attr('href');
    });

    // Prevent anchor tags from default behavior
    $('.get-back-to-albums-container a, .pshowgallerylink a, #module-pshowgallery-album .album-single-item a').on('click', function (e) {
        e.preventDefault();
    });

    // Show popup gallery
    $('#module-pshowgallery-album .album-single-item').on('click', function (e) {
        let indexOfdAlbumSingleItem = $(this).index();
        initSlider(indexOfdAlbumSingleItem);

        $('body').css({'overflow': 'hidden'});

        $('.popup-album-list-item-container').css({'display': 'flex'}).fadeTo("fast", 1);
    });

    // Hide popup gallery
    $('.popup-album-list-item-container, .close-box').on('click', function (e) {
        $(this).fadeTo("fast", 0, function () {
            $(this).css({'display': 'none'});
            $('.popup-album-list-item').slick('unslick');
        })

        $('body').css({'overflow': 'unset'});
    })

    // prevent .popup-album-list-item from closing popup
    $('.popup-album-list-item').on('click', function (e) {
        return false;
    })

    // check if body has class of album-list page
    if ($('body#module-pshowgallery-album')) {
        albumListWidth = $('.album-list').width();
        albumScrollerWidth = $('.album-scroller')[0].scrollWidth;
    }

    if (albumScrollerWidth <= albumListWidth) {
        $('section.album-list .left-arrow-container').css({'display': 'none'});
        $('section.album-list .right-arrow-container').css({'display': 'none'});

        $('.album-scroller').css({'cursor': 'normal'});
    } else {
        $('section.album-list .left-arrow-container').css({'display': 'flex'});
        $('section.album-list .right-arrow-container').css({'display': 'flex'});

        $('.album-scroller').css({'cursor': 'move'});
    }

    // set album-list-item height same as its width
    if ($('body#module-pshowgallery-album')) {
        albumSingleItemWidth = $('.album-list-item').children().eq(1).width();
        $('.album-list-item').css({'grid-auto-rows': albumSingleItemWidth});
    }

    $(window).resize(function () {
        albumListWidth = $('.album-list').width();
        albumScrollerWidth = $('.album-scroller')[0].scrollWidth;

        if (albumScrollerWidth <= albumListWidth) {
            $('section.album-list .left-arrow-container').css({'display': 'none'});
            $('section.album-list .right-arrow-container').css({'display': 'none'});
        } else {
            $('section.album-list .left-arrow-container').css({'display': 'flex'});
            $('section.album-list .right-arrow-container').css({'display': 'flex'});
        }

        if ($('body#module-pshowgallery-album')) {
            albumSingleItemWidth = $('.album-list-item').children().eq(1).width();
            $('.album-list-item').css({'grid-auto-rows': albumSingleItemWidth});
        }

    });

    function initSlider(index) {
        if (!($('.popup-album-list-item').hasClass("slick-initialized"))) {
            $('.popup-album-list-item').slick({
                arrows: true,
                lazyLoad: 'ondemand',
                infinite: true,
                variableWidth: true,
                centerMode: true,
                slidesToShow: 1,
                initialSlide: index,
                prevArrow: '<div class="arrow-prev"><i class="material-icons">navigate_before</i></div>',
                nextArrow: '<div class="arrow-next"><i class="material-icons">navigate_next</i></div>',

                responsive: [
                    {
                        breakpoint: 769,
                        settings: {
                            variableWidth: false,
                            centerMode: false,
                            lazyLoad: 'ondemand',
                            initialSlide: index,
                        }
                    }
                ]
            });
        }
    }

});


