<?php

class ProductController extends ProductControllerCore {

    public function initContent() {
        parent::initContent();
        if (Module::isEnabled('pshowgallery')) {
            $this->product->description = PShowGallery::getHooksFromContent($this->product->description);
            if(version_compare(_PS_VERSION_, '1.7.0', '>='))
            {
            	$product_for_template = $this->getTemplateVarProduct();
            	
            	$filteredProduct = Hook::exec(
            			'filterProductContent',
            			array('object' => $product_for_template),
            			null,
            			false,
            			true,
            			false,
            			null,
            			true
            			);
            	if (!empty($filteredProduct['object'])) {
            		$product_for_template = $filteredProduct['object'];
            	}
            	$product_for_template["description"] = $this->product->description;
            	$this->context->smarty->assign('product', $product_for_template);
            	$this->assignAttributesGroups($product_for_template);
            }
            else
            {
            	$this->context->smarty->assign('product', $this->product);
            }
            
        }
    }
}
