<?php
/**
* 2014-2020 PrestaDev.pl
*
* NOTICE OF LICENSE
*
* Obiekt automatycznie wygenerowany za pomocą narzędzia ObjectGenerator
* http://PrestaDev.pl
*
* DISCLAIMER
*
*
*  @author    PrestaDev.pl <info@prestadev.pl>
*  @copyright 2014-2020 PrestaDev.pl
*  @license   Licecnja na jedną domenę
*  PrestaDev.pl
*/

class PaczkomatyList extends ObjectModel
{
    /* Classic fields */
    public $id;
    /** @var string id_cart */
    public $id_cart;
    /** @var string machine */
    public $machine;
    /** @var string nr_listu */
    public $nr_listu;
    /** @var string status */
    public $status;
    /** @var string post_info */
    public $post_info;
    /** @var string id_pack */
    public $id_pack;
    /** @var int pack_type */
    public $pack_type;
    /** @var string pack_status */
    public $pack_status;

    public static $definition = array(
        'table' => 'pdinpostpaczkomatylist',
        'primary' => 'id',
        'multilang' => false,
        'multilang_shop' => false,
        'fields' => array(
            /* Classic fields */
            'id_cart' => array(
                'type' => self::TYPE_STRING,
                'size' => 100,
            ),
            'machine' => array(
                'type' => self::TYPE_STRING,
                'size' => 255,
            ),
            'nr_listu' => array(
                'type' => self::TYPE_STRING,
                'size' => 255,
            ),
            'status' => array(
                'type' => self::TYPE_STRING,
                'size' => 255,
            ),
            'post_info' => array(
                'type' => self::TYPE_STRING,
            ),
            'id_pack' => array(
                'type' => self::TYPE_STRING,
                'size' => 255,
            ),
            'pack_type' => array(
                'type' => self::TYPE_INT,
                'size' => 11,
            ),
            'pack_status' => array(
                'type' => self::TYPE_STRING,
                'size' => 255,
            ),


        ),
    );

    public static function installSql()
    {
        $sql = array();
        $sql[] = '
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'pdinpostpaczkomatylist`
            (
              `id` INT(11) UNSIGNED PRIMARY KEY AUTO_INCREMENT,
              `id_cart` CHAR(100) ,
              `machine` CHAR(255) ,
              `nr_listu` CHAR(255) ,
              `status` CHAR(255) ,
              `post_info` LONGTEXT ,
              `id_pack` CHAR(255) ,
              `zlecenie` CHAR(255) ,
              `pack_type` INT(11) ,
              `pack_status` CHAR(255)
            ) CHARACTER SET utf8 COLLATE utf8_general_ci;';

        foreach ($sql as $item) {
            if (!Db::getInstance()->execute($item)) {
                return false;
            }
        }
        return true;
    }

    public function __construct($id = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id, $id_lang, $id_shop);
        $this->post_info = Tools::stripslashes($this->post_info);
    }

    public static function uninstallSql()
    {
        $sql = array();
        $sql[] = 'DROP TABLE IF EXISTS `'._DB_PREFIX_.'pdinpostpaczkomatylist`';

        foreach ($sql as $item) {
            if (!Db::getInstance()->execute($item)) {
                return false;
            }
        }
        return true;
    }

    public static function update268()
    {
        try {
            $sql = '
            ALTER TABLE `'._DB_PREFIX_.'pdinpostpaczkomatylist` 
            ADD COLUMN zlecenie char(255)';
            Db::getInstance()->execute($sql);
        } catch (Exception $exp) {
        }
    }

    public static function update262()
    {
        $sql = '
            ALTER TABLE                 `'._DB_PREFIX_.'pdinpostpaczkomatylist` 
            CONVERT TO CHARACTER SET    utf8 
            COLLATE                     utf8_general_ci';
        Db::getInstance()->execute($sql);
    }

    public static function update256()
    {
        try {
            $sql = '
            ALTER TABLE `'._DB_PREFIX_.'pdinpostpaczkomatylist`
            ADD COLUMN pack_type int(11) DEFAULT 0,
            ADD COLUMN pack_status CHAR(255)';
            Db::getInstance()->execute($sql);
        } catch (Exception $exp) {
        }
    }

    public static function update259()
    {
        try {
            $sql = '
                ALTER TABLE `'._DB_PREFIX_.'pdinpostpaczkomatylist`
                ADD COLUMN pack_status CHAR(255)';
            Db::getInstance()->execute($sql);
        } catch (Exception $exp) {
        }
        try {
            $sql = '
                ALTER TABLE `'._DB_PREFIX_.'pdinpostpaczkomatylist`
                ADD COLUMN id_pack CHAR(255)';
            Db::getInstance()->execute($sql);
        } catch (Exception $exp) {
        }

        try {
            $sql = '
                ALTER TABLE `'._DB_PREFIX_.'pdinpostpaczkomatylist`
                ADD COLUMN pack_type int(11) DEFAULT 0';
            Db::getInstance()->execute($sql);
        } catch (Exception $exp) {
        }
    }

    public static function getSelectedMachine($id_cart)
    {
        $sql = '
            SELECT      machine 
            FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
            WHERE   id_cart = '.(int)$id_cart.' 
            ORDER   BY id DESC';
        $machine = Db::getInstance()->getValue($sql);
        if ($machine === false) {
            return '';
        } else {
            return $machine;
        }
    }

    public static function getPostInfoByIdCart($id_cart)
    {
        $sql = '
            SELECT      post_info 
            FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
            WHERE   id_cart = '.(int)$id_cart.' 
            ORDER   BY id DESC';
        return Tools::stripslashes(Db::getInstance()->getValue($sql));
    }

    public static function getByIdCart($id_cart)
    {
        if (Tools::isSubmit('id')) {
            $sql = '
                SELECT      id 
                FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
                WHERE   id_cart = '.(int)$id_cart.'
                AND     id = '.(int)Tools::getValue('id').' 
                ORDER   BY id DESC';
            $id = Db::getInstance()->getValue($sql);
        } else {
            $sql = '
                SELECT      id 
                FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
                WHERE   id_cart = '.(int)$id_cart.' 
                ORDER   BY id DESC';
            $id = Db::getInstance()->getValue($sql);
        }
        if ($id) {
            $paczkomatyList = new PaczkomatyList($id);
        } else {
            $paczkomatyList = new PaczkomatyList();
            $paczkomatyList->id_cart = $id_cart;
        }
        return $paczkomatyList;
    }

    public static function createEmpty($id_cart)
    {
        $sql = '
            SELECT      id 
            FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
            WHERE   id_cart = '.(int)$id_cart.' 
            ORDER   BY id DESC';
        $id = Db::getInstance()->getValue($sql);
        if ($id) {
            $paczkomatyList = new PaczkomatyList($id);
            $paczkomatyList->id = false;
            $paczkomatyList->post_info = '';
            $paczkomatyList->nr_listu = '';
            $paczkomatyList->pack_status = '';
            $paczkomatyList->status = '';
            $paczkomatyList->save();
        }
        return $paczkomatyList;
    }

    public static function getNrListuByIdCart($id_cart)
    {
        if (Tools::isSubmit('id')) {
            $sql = '
                SELECT      nr_listu 
                FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
                WHERE   id_cart = '.(int)$id_cart.' 
                AND     id = '.(int)Tools::getValue('id').'
                ORDER   BY id DESC';
            return Db::getInstance()->getValue($sql);
        } else {
            $sql = '
                SELECT      nr_listu 
                FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
                WHERE   id_cart = '.(int)$id_cart.' 
                ORDER   BY id DESC';
            return Db::getInstance()->getValue($sql);
        }
    }

    public static function getObjectByShippingNumber($shipping_number)
    {
        $sql = '
            SELECT      id 
            FROM    `'._DB_PREFIX_.'pdinpostpaczkomatylist`
            WHERE   nr_listu = "'.(string)pSql($shipping_number).'"';
        $id = Db::getInstance()->getValue($sql);
        if ($id) {
            return new PaczkomatyList($id);
        } else {
            return false;
        }
    }

    public static function getPackages($id_cart)
    {
        $sql = '
            SELECT      id,nr_listu 
            FROM        `'._DB_PREFIX_.'pdinpostpaczkomatylist` 
            WHERE       id_cart = '.(int)$id_cart.'
            ORDER BY    id ASC';
        return Db::getInstance()->executeS($sql);
    }
}
