<?php

/**
 * File from http://PrestaShow.pl
 *
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 * @authors     PrestaShow.pl <kontakt@prestashow.pl>
 * @copyright   2016 PrestaShow.pl
 * @license     http://PrestaShow.pl/license
 */

namespace Prestashow\PShowGallery\Entity;

use Prestashow\PrestaCore\Model\AbstractEntity;
use Context;
use Db;
use Shop;
use Validate;

class PShowGalleryAlbum extends AbstractEntity
{
    /** @var integer album ID */
    public $id_pshow_gallery_album;

    /** @var string name */
    public $name;

    /** @var string Link rewrite */
    public $link_rewrite;

    /** @var string desc */
    public $description;

    /** @var bool active */
    public $active;

    /** @var string Object creation date */
    public $date_add;

    /** @var string Object last modification date */
    public $date_upd;

    /** @var integer position */
    public $position;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'pshow_gallery_album',
        'primary' => 'id_pshow_gallery_album',
        'multilang' => true,
        'multilang_shop' => true,
        'fields' => array(
            'active' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'required' => true),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
            'position' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),

            /* Lang fields */
            'name' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCatalogName', 'required' => true),
            'description' => array('type' => self::TYPE_HTML, 'lang' => true, 'validate' => 'isCleanHtml'),
            'link_rewrite' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isLinkRewrite', 'required' => true, 'size' => 128)
        )
    );

    public function __construct($id_album = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id_album, $id_lang, $id_shop);
    }

    public static function getAlbums($id_lang, $id_shop, $getObjects = false)
    {
        $q = "SELECT c.`id_pshow_gallery_album`, cl.`name`
            FROM `" . _DB_PREFIX_ . "pshow_gallery_album` c
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_album_lang` cl ON (
                    cl.`id_pshow_gallery_album` = c.`id_pshow_gallery_album` AND
                    cl.`id_lang` = " . (int)$id_lang . "
            )
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_album_shop` cs ON (
                    cs.`id_pshow_gallery_album` = c.`id_pshow_gallery_album` AND
                    cs.`id_shop` = " . (int)$id_shop . "
            )
			WHERE c.`active` = 1
			ORDER BY c.`position` ASC;";

        $tmp = Db::getInstance()->query($q);

        if (!$getObjects)
            return $tmp;

        $albums = array();

        foreach ($tmp as $album) {
            $albums[] = new PShowGalleryAlbum($album['id_pshow_gallery_album'], $id_lang, $id_shop);
        }

        return $albums;
    }

    public function getImages()
    {
        return PShowGalleryImage::getImages(Context::getContext()->cookie->id_lang, $this->id);
    }

    public function getCoverId()
    {
        $cover = PShowGalleryImage::getImages(Context::getContext()->cookie->id_lang, $this->id, true, 1);
        if (!$cover) {
            return 0;
        }
        return $cover['id_pshow_gallery_image'];
    }

    public static function countImages($id_album)
    {
        $context = Context::getContext();

        return count(PShowGalleryImage::getImages($context->cookie->id_lang, $id_album));
    }

    public static function countAlbums($id_shop)
    {
        $q = "SELECT COUNT(*)
            FROM `" . _DB_PREFIX_ . "pshow_gallery_album` c
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_album_shop` cs ON (
                    cs.`id_pshow_gallery_album` = c.`id_pshow_gallery_album` AND
                    cs.`id_shop` = " . (int)$id_shop . ")";

        $query = Db::getInstance()->getValue($q);

        if ($query === false)
            return false;

        return $query;
    }

    public function updatePosition($way, $position)
    {
        if (!$res = Db::getInstance()->executeS('
			SELECT `id_pshow_gallery_album`, `position`
			FROM `' . _DB_PREFIX_ . 'pshow_gallery_album`
			ORDER BY `position` ASC')
        ) {
            return false;
        }

        foreach ($res as $album) {
            if ((int)$album['id_pshow_gallery_album'] == (int)$this->id_pshow_gallery_album) {
                $moved_album = $album;
            }
        }

        if (!isset($moved_album) || !isset($position)) {
            return false;
        }

        return (Db::getInstance()->execute('
			UPDATE `' . _DB_PREFIX_ . 'pshow_gallery_album`
			SET `position` = `position` ' . ($way ? '- 1' : '+ 1') . '
			WHERE `position`
			' . ($way
                    ? '> ' . (int)$moved_album['position'] . ' AND `position` <= ' . (int)$position
                    : '< ' . (int)$moved_album['position'] . ' AND `position` >= ' . (int)$position))
            && Db::getInstance()->execute('
			UPDATE `' . _DB_PREFIX_ . 'pshow_gallery_album`
			SET `position` = ' . (int)$position . '
			WHERE `id_pshow_gallery_album` = ' . (int)$moved_album['id_pshow_gallery_album']));
    }

    public function add($autodate = true, $null_values = false, $id_shop = false)
    {
        $ret = parent::add($autodate, $null_values);

        $this->addShop($id_shop);

        return $ret;
    }

    public function update($null_values = false)
    {
        return parent::update($null_values);
    }

    /**
     * Add association between shop and albums
     * @param int $id_shop
     * @return bool
     */
    public function addShop($id_shop)
    {
        $data = array();
        if (!$id_shop) {
            foreach (Shop::getShops(false) as $shop)
                if (!$this->existsInShop($shop['id_shop']))
                    $data[] = array(
                        'id_pshow_gallery_album' => (int)$this->id,
                        'id_shop' => (int)$shop['id_shop'],
                    );
        } else if (!$this->existsInShop($id_shop))
            $data[] = array(
                'id_pshow_gallery_album' => (int)$this->id,
                'id_shop' => (int)$id_shop,
            );

        return Db::getInstance()->insert('pshow_gallery_album_shop', $data);
    }

    public function existsInShop($id_shop)
    {
        return (bool)Db::getInstance()->getValue('
            SELECT `id_pshow_gallery_album`
            FROM `' . _DB_PREFIX_ . 'pshow_gallery_album_shop`
            WHERE `id_pshow_gallery_album` = ' . (int)$this->id . '
            AND `id_shop` = ' . (int)$id_shop);
    }

    public static function getFullAlbumsByTags($tags, $id_lang, $id_shop)
    {
        $albums = false;
        if ($tags) {
            $temp = explode(",", $tags);
            foreach ($temp as &$obj) {
                $obj = "'" . trim($obj) . "'";
            }
            $tags = implode(",", $temp);

            $q = "SELECT count(*) FROM `" . _DB_PREFIX_ . "pshow_gallery_album` c
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_album_lang` cl ON (
                    cl.`id_pshow_gallery_album` = c.`id_pshow_gallery_album` AND
                    cl.`id_lang` = " . (int)$id_lang . "
            )
            JOIN `" . _DB_PREFIX_ . "pshow_gallery_album_shop` cs ON (
                    cs.`id_pshow_gallery_album` = c.`id_pshow_gallery_album` AND
                    cs.`id_shop` = " . (int)$id_shop . "
            )
			JOIN " . _DB_PREFIX_ . "pshow_gallery_album_tag pt ON (
						pt.id_pshow_gallery_album = c.id_pshow_gallery_album
					)
					JOIN `" . _DB_PREFIX_ . "pshow_gallery_tag` t ON (
						pt.id_pshow_gallery_tag = t.id_pshow_gallery_tag AND
						t.`id_lang` = " . (int)$id_lang . "
					)
			WHERE t.`name` IN (" . $tags . ")
					AND c.`active` = 1
			GROUP BY c.`id_pshow_gallery_album`
			ORDER BY c.`position` ASC;";

            $albums_count = Db::getInstance()->getValue($q);

            if ($albums_count) {
                $q = "SELECT * FROM `" . _DB_PREFIX_ . "pshow_gallery_album` c
		            JOIN `" . _DB_PREFIX_ . "pshow_gallery_album_lang` cl ON (
		                    cl.`id_pshow_gallery_album` = c.`id_pshow_gallery_album` AND
		                    cl.`id_lang` = " . (int)$id_lang . "
		            )
		            JOIN `" . _DB_PREFIX_ . "pshow_gallery_album_shop` cs ON (
		                    cs.`id_pshow_gallery_album` = c.`id_pshow_gallery_album` AND
		                    cs.`id_shop` = " . (int)$id_shop . "
		            )
					JOIN " . _DB_PREFIX_ . "pshow_gallery_album_tag pt ON (
								pt.id_pshow_gallery_album = c.id_pshow_gallery_album
							)
							JOIN `" . _DB_PREFIX_ . "pshow_gallery_tag` t ON (
								pt.id_pshow_gallery_tag = t.id_pshow_gallery_tag AND
								t.`id_lang` = " . (int)$id_lang . "
							)
					WHERE t.`name` IN (" . $tags . ")
					AND c.`active` = 1
					GROUP BY c.`id_pshow_gallery_album`
					ORDER BY c.`position` ASC;";
                $albums = Db::getInstance()->executeS($q);
            }
        }
        return $albums;
    }

    public static function getTagsBylang($id_album, $id_lang = null, $asText = true)
    {
        if ($id_lang == null) {
            $id_lang = (int)Context::getContext()->language->id;
        }
        $tags = '';
        if (!$tmp = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
                    SELECT  t.`name`, t.`id_pshow_gallery_tag`
                    FROM ' . _DB_PREFIX_ . 'pshow_gallery_tag t
                    LEFT JOIN ' . _DB_PREFIX_ . 'pshow_gallery_album_tag pt ON (pt.id_pshow_gallery_tag = t.id_pshow_gallery_tag AND t.id_lang = ' . $id_lang . ')
					LEFT JOIN ' . _DB_PREFIX_ . 'pshow_gallery_album e ON (pt.id_pshow_gallery_album = e.id_pshow_gallery_album)
                    WHERE pt.`id_pshow_gallery_album`=' . (int)$id_album . ' AND e.`active` = 1'))
            return false;
        if ($asText) {
            $i = 1;
            foreach ($tmp as $val) {
                if ($i >= count($tmp)) {
                    $tags .= $val['name'];
                } else {
                    $tags .= $val['name'] . ',';
                }
                $i++;
            }
        } else {
            return $tmp;
        }
        return $tags;
    }

    public static function deleteTagsForAlbum($id_album)
    {
        return Db::getInstance()->execute('DELETE FROM `' . _DB_PREFIX_ . 'pshow_gallery_album_tag` WHERE `id_pshow_gallery_album` = ' . (int)$id_album);
    }

    public static function addTags($id_lang = null, $id_album, $tag_list, $separator = ',')
    {
        if ($id_lang == null) {
            $id_lang = (int)Context::getContext()->language->id;
        }
        if (!Validate::isUnsignedId($id_lang))
            return false;

        if (!is_array($tag_list))
            $tag_list = array_filter(array_unique(array_map('trim', preg_split('#\\' . $separator . '#', $tag_list, null, PREG_SPLIT_NO_EMPTY))));

        $list = array();
        if (is_array($tag_list))
            foreach ($tag_list as $tag) {
                $id_tag = PShowGalleryTag::isTag($tag, (int)$id_lang);
                if (!$id_tag) {
                    $tag_obj = new PShowGalleryTag(null, $tag, (int)$id_lang);
                    if (!Validate::isLoadedObject($tag_obj)) {
                        $tag_obj->name = $tag;
                        $tag_obj->id_lang = (int)$id_lang;
                        $tag_obj->add();
                    }
                    if (!in_array($tag_obj->id, $list))
                        $list[] = $tag_obj->id;
                } else {
                    if (!in_array($id_tag, $list))
                        $list[] = $id_tag;
                }

            }
        $data = '';
        foreach ($list as $tag)
            $data .= '(' . (int)$tag . ',' . (int)$id_album . '),';
        $data = rtrim($data, ',');

        return Db::getInstance()->execute('
		INSERT INTO `' . _DB_PREFIX_ . 'pshow_gallery_album_tag` (`id_pshow_gallery_tag`, `id_pshow_gallery_album`)
		VALUES ' . $data);
    }
}
